%%%% A Matlab Code for 2D Non-Penalization SEMDOT Algorithm %%%%
% Example SEMDOT2D(40, 0.3, 2, 2, 1)
function SEMDOT2D(nelx, vol, rmin, ctp, index_initial)
nely=nelx; nG=10; 
%% PRE HOMONGENIZATION
nel=nely*nelx;
nodenrs=reshape(1:(1+nelx)*(1+nely),1+nely,1+nelx);
edofVec=reshape(2*nodenrs(1:end-1,1:end-1)+1,nel,1);
edofMat=repmat(edofVec,1,8)+repmat([0 1 2*nely+[2 3 0 1] -2 -1],nel,1);
%% IMPOSE PERIODIC BOUNDARY CONDITIONS
nn=(nelx+1)*(nely+1);
nnP=(nelx)*(nely); ndof=2*nnP;
nnPArray=reshape(1:nnP,nely,nelx);
nnPArray(end+1,:)=nnPArray(1,:);
nnPArray(:,end+1)=nnPArray(:,1);
dofVector=zeros(2*nn, 1);
dofVector(1:2:end)=2*nnPArray(:)-1;
dofVector(2:2:end)=2*nnPArray(:);
edofMat=dofVector(edofMat);
%% INITIALIZATION
ly=1; lx=ly; dx=lx/nelx; dy=ly/nely;
vx=initial_x(nelx,nely,vol,index_initial);
E=1; NU=0.3;
vxPhys=vx;
Emin=1e-9; maxloop=1000; ngrid=nG-1; tolx=0.001;
E0=1; rnmin=1; scale_obj=1;
%% ELEMENTAL NODES AND COORDINATES
[nodex,nodey]=meshgrid(0:nelx,0:nely);
[fnx,fny]=meshgrid(0:1/ngrid:nelx,0:1/ngrid:nely);
%% INITIALIZE MMA OPTIMIZER
nele=nely*nelx; m=1; n = nely*nelx; nelm=nely*nelx;
vxmin=1e-3*ones(nelm,1); vxmax=ones(nelm,1);
vxold1=vx(:); vxold2=vxold1;
a0 = 1; ai = 0; ci = 1000; di = 0; low=ones(nelm,1); upp=1;
%% PRE HOMOGENIZATION
D=[1 NU 0;NU 1 0;0 0 (1-NU)/2]/(1-NU*NU);
nodes=[0,0;dx,0;dx,dy;0,dy];
gaussp=[-1 -1;1 -1;1 1;-1 1]*1/sqrt(3);
KE=0; FE=0;
for i=1:4
    s=gaussp(i,1);t=gaussp(i,2);
    J1=[-(1-t) 1-t 1+t -(1+t);-(1-s) -(1+s) 1+s 1-s]/4; J=J1*nodes;
    DN_XY=inv(J)*J1;
    B1=[DN_XY(1,1) 0;0 DN_XY(2,1);DN_XY(2,1) DN_XY(1,1)];
    B2=[DN_XY(1,2) 0;0 DN_XY(2,2);DN_XY(2,2) DN_XY(1,2)];
    B3=[DN_XY(1,3) 0;0 DN_XY(2,3);DN_XY(2,3) DN_XY(1,3)];
    B4=[DN_XY(1,4) 0;0 DN_XY(2,4);DN_XY(2,4) DN_XY(1,4)];
    B=[B1 B2 B3 B4];
    KE=KE+B'*D*B*det(J);
    FE=FE+B'*D*diag([1 1 1])*det(J); clear J
end
%% PREPARE FILTER
[H,Hs]=HHs(nelx,nely,rmin);
[Hn,Hns]=HnHns(nelx,nely,rnmin);
%% INITIALIZE HEAVISIDE SMOOTH FUNCTION
beta=0.5; ER=0.5;
change=1;
loop=0;
%% START ITERATION
while (change > tolx || tol>0.001) && loop < maxloop
    loop=loop+1;
    Ee=(vxPhys.*E0+(1-vxPhys).*(Emin*E0));
    dEe=((1-vxPhys)*Emin+vxPhys).*E0;
    %% ASSEMBLE STIFFNESS MATRIX
    iK=kron(edofMat,ones(8,1))';
    jK=kron(edofMat,ones(1,8))';
    sK=KE(:)*Ee(:)';
    K=sparse(iK(:), jK(:), sK(:), ndof, ndof);
    %% LOAD VECTORS AND SOLUTION
    sF=FE(:)*Ee(:)';
    iF=repmat(edofMat',3,1);
    jF=[ones(8,nel); 2*ones(8,nel); 3*ones(8,nel)];
    F=sparse(iF(:), jF(:), sF(:), ndof, 3);
    chi(3:ndof,:)=K(3:ndof,3:ndof)\F(3:ndof,:);
    chi0=zeros(nel, 8, 3);
    chi0_e=zeros(8, 3);
    chi0_e([3 5:end],:)=KE([3 5:end],[3 5:end])\FE([3 5:end],:);
    chi0(:,:,1)=kron(chi0_e(:,1)', ones(nel,1));
    chi0(:,:,2)=kron(chi0_e(:,2)', ones(nel,1));
    chi0(:,:,3)=kron(chi0_e(:,3)', ones(nel,1));
    CH=zeros(3); dCH=cell(3,3);
    for i=1:3
        for j=1:3
            sumKE=((chi0(:,:,i)-chi(edofMat+(i-1)*ndof))*KE).*(chi0(:,:,j)-chi(edofMat+(j-1)*ndof));
            sumK=Ee.*reshape(sum(sumKE,2), nely, nelx);
            dsumK=dEe.*reshape(sum(sumKE,2), nely, nelx);
            CH(i,j)=sum(sum(sumK))/(lx*ly);
            dCH{i,j}=dsumK/(lx*ly);
        end
    end
    CH=(CH+CH')/2;
    dCH{1,2}=(dCH{1,2}+dCH{2,1})/2;
    dCH{1,3}=(dCH{1,3}+dCH{3,1})/2;
    dCH{2,3}=(dCH{2,3}+dCH{3,2})/2;
    dCH{2,1}=dCH{1,2}; dCH{3,1}=dCH{1,3}; dCH{3,2}=dCH{2,3};
    %% POST HOMOGENIZATION
    switch(ctp)
        case 1 % Bulk modulus maximization
            c(loop,1)=(CH(1,1)+CH(1,2)+CH(2,1)+CH(2,2))/4;
            dc=(dCH{1,1}+dCH{1,2}+dCH{2,1}+dCH{2,2})/4;
        case 2 % Shear modulus maximization
            c(loop,1)=CH(3,3);
            dc=dCH{3,3};
    end
    dc=-dc;
    dv=ones(nely,nelx);
    %% FILTERING/MODIFICATION OF SENSITIVITIES
    dc(:)=H*(dc(:)./Hs);
    dv(:)=H*(dv(:)./Hs);
    %%  UPDATE DESIGN VARIABLES AND FILTERED ELEMENTAL VOLUME FRACTIONS
    vxval=vx(:);
    f0val=scale_obj.*c; df0dx=scale_obj.*dc(:);
    fval=sum(vxPhys(:))/(vol*nely*nelx)-1;
    dfdx=dv(:)'/(vol*nely*nelx);
    [vxmma,~,~,~,~,~,~,~,~,low,upp] = ...
        mmasub(m,n,loop,vxval,vxmin,vxmax,vxold1,vxold2,f0val,df0dx,fval,dfdx,low,upp,a0,ai,ci,di);
    vxnew=reshape(vxmma,nely,nelx); vxold2=vxold1(:); vxold1=vx(:);
    vxPhys(:)=(H*vxnew(:))./Hs;
    xn=reshape((Hn*vxPhys(:)./Hns),nely+1,nelx+1);
    %% UPDATE POINT DESNIGY BY A HEAVISIDE SMOOTH/STEP FUNCTION
    xg=interp2(nodex,nodey,xn,fnx,fny,'linear');
    l1=0; l2=1;
    while (l2-l1)>1e-5
        ls=(l1+l2)/2;
        xgnew=max(0.001,(tanh(beta*ls)+tanh(beta*(xg-ls)))/(tanh(beta*ls)+tanh(beta*(1-ls))));
        if sum(sum(xgnew))/((ngrid*nelx+1)*(ngrid*nely+1))-sum(vxPhys(:))/(nelx*nely)>0, l1=ls; else, l2=ls; end
    end
    %% ASSEMBLE GRID POINTS TO ELEMENTS
    vxPhys(:)=0;
    Terr=0; Tm=[];
    for i=1:nelx
        for j=1:nely
            e=(i-1)*nely+j;
            for i1=ngrid*(i-1)+1:ngrid*i+1
                for j1 = ngrid*(j-1)+1:ngrid*j+1
                    Tm = [Tm;xgnew(j1,i1)];
                    vxPhys(e)=vxPhys(e)+xgnew(j1,i1);
                end
            end
            if min(Tm)>0.001 && max(Tm)<1, Terr=Terr+1; end
            Tm=[];
        end
    end
    vxPhys=vxPhys/(ngrid+1)^2;
    %% CHECK CONVERGENCE
    change=sum(abs(vxnew(:)-vx(:)))/(vol*nely*nelx);
    tol=Terr/nele;
    vx=vxnew;
    %% PLOT RESULTS
    fprintf('It.:%3i Obj.:%8.4f Vol.:%4.3f ch.:%4.5f Topo.:%7.5f Beta.:%g.\n',loop,c(loop),mean(vxPhys(:)),change,tol,beta);
    contourf(fnx, flipud(fny), xg-ls, [0 0]);
    axis equal tight off; drawnow
    %% UPDATE HEAVISIDE SMOOTH FUNCTION
    beta=beta+ER;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This code was written by:                                               %
%                                                                         %
% Dr. Yun-Fei Fu                                                          %
% Department of Mechanical Engineering, University of Alberta, Canada     %
%                                                                         %
% Prof. Bernard Rolfe                                                     %
% School of Engineering, Faculty of Science Engineering and               %
% Built Environment, Deakin University, Australia                         %
%                                                                         %
% Please send your comments and questions to: jackyunfei.fu@outlook.com   %
%                                                                         %
% The code is intended for educational purposes and theoretical details   %
% are discussed in the book: "Smooth Topological Design of Continuum      %
% Structures", YF Fu and B Rolfe, CRC press.                              %
%                                                                         %
%                                                                         %
% E Andreassen and CS Andreasen. How to determine composite material      %  
% properties using numerical homogenization. Computational Materials      %
% Science 83 (2014): 488-495. doi: 10.1016/j.commatsci.2013.09.006        %
%                                                                         %
% Disclaimer:                                                             %
% The authors do not guarantee that the code is free from errors.         %
% Furthermore, the authors shall not be liable in any event caused by the %
% use of the program.                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%









